#!/bin/bash
cd "$(dirname "$0")"

PROCESS_NAME="dxprint"

echo "Verificare instante anterioare de $PROCESS_NAME..."

# pgrep -x gaseste doar potrivirea exacta a numelui executabilului
PID=$(pgrep -x "$PROCESS_NAME")

if [ -n "$PID" ]; then
    echo "S-a gasit o instanta activa (PID: $PID). Se opreste..."

    # Trimitem semnal SIGTERM (15) pentru inchidere graceful
    kill -15 "$PID"

    # Asteptam putin sa se opreasca
    sleep 2

    # Verificam daca s-a oprit
    if pgrep -x "$PROCESS_NAME" > /dev/null; then
        echo "Procesul nu s-a oprit graceful. Se forteaza oprirea (SIGKILL)..."
        kill -9 "$PID"
    else
        echo "Procesul anterior a fost oprit cu succes."
    fi
else
    echo "Nu s-au gasit instante active."
fi

echo "Pornire instanta noua..."
./$PROCESS_NAME